BuildNo="SpaceCindy Build.181224";

Lightpoint=[-1,1,1];  // 光源

Colname=[
["greenyellow",[0.15,0,0.69,0]],
["yellow",[0,0,1,0]],
["Yellow",[0,0,1,0]],
["goldenrod",[0,0.1,0.84,0]],
["dandelion",[0,0.29,0.84,0]],
["apricot",[0,0.32,0.52,0]],
["peach",[0,0.5,0.7,0]],
["melon",[0,0.46,0.5,0]],
["yelloworange",[0,0.42,1,0]],
["orange",[0,0.61,0.87,0]],
["burntorange",[0,0.51,1,0]],
["bittersweet",[0,0.75,1,0.24]],
["redorange",[0,0.77,0.87,0]],
["mahogany",[0,0.85,0.87,0.35]],
["maroon",[0,0.87,0.68,0.32]],
["brickred",[0,0.89,0.94,0.28]],
["red",[0,1,1,0]],
["Red",[0,1,1,0]],
["orangered",[0,1,0.5,0]],
["rubinered",[0,1,0.13,0]],
["wildstrawberry",[0,0.96,0.39,0]],
["salmon",[0,0.53,0.38,0]],
["carnationpink",[0,0.63,0,0]],
["magenta",[0,1,0,0]],
["Magenta",[0,1,0,0]],
["violetred",[0,0.81,0,0]],
["rhodamine",[0,0.82,0,0]],
["mulberry",[0.34,0.9,0,0.02]],
["redviolet",[0.07,0.9,0,0.34]],
["fuchsia",[0.47,0.91,0,0.08]],
["lavender",[0,0.48,0,0]],
["thistle",[0.12,0.59,0,0]],
["orchid",[0.32,0.64,0,0]],
["darkorchid",[0.4,0.8,0.2,0]],
["purple",[0.45,0.86,0,0]],
["plum",[0.5,1,0,0]],
["violet",[0.79,0.88,0,0]],
["royalpurple",[0.75,0.9,0,0]],
["blueviolet",[0.86,0.91,0,0.04]],
["periwinkle",[0.57,0.55,0,0]],
["cadetblue",[0.62,0.57,0.23,0]],
["cornflowerblue",[0.65,0.13,0,0]],
["midnightblue",[0.98,0.13,0,0.43]],
["navyblue",[0.94,0.54,0,0]],
["royalblue",[1,0.5,0,0]],
["blue",[1,1,0,0]],
["Blue",[1,1,0,0]],
["cerulean",[0.94,0.11,0,0]],
["cyan",[1,0,0,0]],
["Cyan",[1,0,0,0]],
["processblue",[0.96,0,0,0]],
["skyblue",[0.62,0,0.12,0]],
["turquoise",[0.85,0,0.2,0]],
["tealblue",[0.86,0,0.34,0.02]],
["aquamarine",[0.82,0,0.3,0]],
["bluegreen",[0.85,0,0.33,0]],
["emerald",[1,0,0.5,0]],
["junglegreen",[0.99,0,0.52,0]],
["seagreen",[0.69,0,0.5,0]],
["green",[1,0,1,0]],
["Green",[1,0,1,0]],
["forestgreen",[0.91,0,0.88,0.12]],
["pinegreen",[0.92,0,0.59,0.25]],
["limegreen",[0.5,0,1,0]],
["yellowgreen",[0.44,0,0.74,0]],
["springgreen",[0.26,0,0.76,0]],
["olivegreen",[0.64,0,0.95,0.4]],
["rawsienna",[0,0.72,1,0.45]],
["sepia",[0,0.83,1,0.7]],
["brown",[0,0.81,1,0.6]],
["tan",[0.14,0.42,0.56,0]],
["gray",[0,0,0,0.5]],
["black",[0,0,0,1]],
["Black",[0,0,0,1]],
["white",[0,0,0,0]];
["White",[0,0,0,0]]];

φ=(1+sqrt(5))/2;   // 黄金比
Rpolydata=[
[[0,0,1],[2*sqrt(2)/3,0,-1/3],[-sqrt(2)/3,sqrt(6)/3,-1/3],[-sqrt(2)/3,-sqrt(6)/3,-1/3]],

[[-1,-1,1],[1,-1,1],[1,1,1],[-1,1,1],[-1,-1,-1],[1,-1,-1],[1,1,-1],[-1,1,-1]],

[[0,0,1],[0,-1,0],[1,0,0],[0,1,0],[-1,0,0],[0,0,-1]],

[[0,-1,-φ^2],[0,1,-φ^2],[0,-1,φ^2],[0,1,φ^2],
[-1,-φ^2,0],[1,-φ^2,0],[-1,φ^2,0],[1,φ^2,0],
[-φ^2,0,-1],[-φ^2,0,1],[φ^2,0,-1],[φ^2,0,1],
[-φ,-φ,-φ],[-φ,-φ,φ],[-φ,φ,-φ],[-φ,φ,φ],
[φ,-φ,-φ],[φ,-φ,φ],[φ,φ,-φ],[φ,φ,φ]],

[[0,-1,-φ],[0,1,-φ],[0,-1,φ],[0,1,φ],
[-φ,0,-1],[-φ,0,1],[φ,0,-1],[φ,0,1],
[-1,-φ,0],[1,-φ,0],[-1,φ,0],[1,φ,0]],
];

rtx(θ):=[[1,0,0],[0,cos(θ),-sin(θ)],[0,sin(θ),cos(θ)]];
rty(θ):=[[cos(θ),0,sin(θ)],[0,1,0],[-sin(θ),0,cos(θ)]];
rtz(θ):=[[cos(θ),-sin(θ),0],[sin(θ),cos(θ),0],[0,0,1]];

constantreset():=(
 RGBcolor=[0.8,1,1];
 CMYKcolor=[0.2,0,0,0];
 Alpha3d=1;
 Mesh=[20,20];
 Rayon=true;
 Contrast=0.8;
);

constantreset();
// 値の取得 ------------------------------------------------
// 視点への単位ベクトルを返す
viewpoint():=(
  regional(v);

  Mat3d=rtz(PHI)*rty(THETA);
  v=rtz(PHI)*rty(THETA)*[0,0,10];
  v/|v|;
);

map2d(pt):=(
  Parapt(pt);
);

// 平面上の点p1,p2,p3 に対し、∠p1p2p3を返す。
angle3pt(p1,p2,p3):=(
 regional(z1,z2,z3,z);

 z1=complex(p1);
 z2=complex(p2);
 z3=complex(p3);
 if(z1==z2,
   0,
   z=(z3-z2)/(z1-z2);
   arctan2(gauss(z));
 );
);

// 平面上で plistで囲まれる閉曲線の中にあるかどうかの判定。ある 1 ない 0 境界線上 2 を返す。plistは閉じていてもいなくてもよい。
pointindomain(p,plist):=(
  regional(n,s,online,th,ret);

  if(plist_1!=plist_(-1),plist=append(plist,plist_1));
  n=length(plist);

  s=0;
  online=false;
  repeat(n-1,t,
   th=angle3pt(plist_t,p,plist_(t+1));
   if(abs(th)==pi % th==0,online=true);
   s=s+th;
  );
  if(online,ret=2,
  // 次の判定、== だと誤差の関係か、やるたびに結果が異なる
      ret=if(abs(s)~=2*pi,1,0);
  );

  ret;
);


// ３点p1,p2,p3を通る平面の法線ベクトルの単位ベクトルを求める
normalvec(p1,p2,p3):=(
  regional(nv,ret);
//  nv=cross(p2-p1,p1-p3);
  nv=cross(p2-p1,p3-p1);
  if(|nv|==0,ret=[0,0,0],ret=nv/|nv|);
  ret;
);

// ３点 p1,p2,p3 を通る平面の方程式 ax+by+cz=1 の係数[a,b,c] を返す
// 係数が決定できないときは [i,i,i] を返す
planecoeff(p1,p2,p3):=(
  regional(MA,ret);

  MA=[p1,p2,p3];

  if(det(MA)==0,
     println(MA+"Warning! Cannot decide a coefficient.");
     ret=[i,i,i];
    ,
    ret=inverse(MA)*[1,1,1];
  );
  ret;
);


// ２点p1,p2を通る直線と点p3の距離。平面でも空間でも使える。
distlp(p1,p2,p3):=(
 regional(t,vh);
  if(|p2-p1|!=0,
    t=(p2-p1)*(p3-p1)/|p2-p1|^2;
    vh=p1+t*(p2-p1);
    abs(vh-p3);
    ,
    println("Warning:p1 is same to p2");
    i;
  );
);


//３点 p1,p2,p3 を通る平面と点p4 の距離
distpp(p1,p2,p3,p4):=(
  regional(nv,hv);
  nv=normalvec(p1,p2,p3);
  hv=interpl(p1,p2,p3,p4,p4+nv);
  if(hv!=[i,i,i],dist(p4,hv),i);
);


// 平面上で線分ABとCDが交わるかどうか。交わればtrue
crosssg(pa,pb,pc,pd):=(
  regional(ca,cb,cd,ab,ad,ac);

  ca=[pa_1-pc_1,pa_2-pc_2,0];
  cb=[pb_1-pc_1,pb_2-pc_2,0];
  cd=[pd_1-pc_1,pd_2-pc_2,0];
  ad=[pd_1-pa_1,pd_2-pa_2,0];
  ab=[pb_1-pa_1,pb_2-pa_2,0];
  ac=[pc_1-pa_1,pc_2-pa_2,0];

  if(cross(cd,ca)*cross(cd,cb)<0 & cross(ab,ad)*cross(ab,ac)<0,true,false);
);

// ４点が同一平面上にあるかどうかの判定
onsameplane(pa,pb,pc,pd):=(
  if((pd-pa)*cross(pb-pa,pc-pa)==0,true,false);
);

// ２点p1,p2を通る直線と２点p4,p5を通る直線の交点
// 存在しないときは [i,i,i] を返す 
interll(p1,p2,p3,p4):=(
  regional(ret);

  ret=[i,i,i];

  MA=[[p2_1-p1_1,p3_1-p4_1],[p2_2-p1_2,p3_2-p4_2]];
  MC=[p3_1-p1_1,p3_2-p1_2];

  if(det(MA)!=0,
    sol=inverse(MA)*MC;
    if(sol_1*[p2_3-p1_3]+sol_2*[p3_3-p4_3]==[p3_3-p1_3],
      ret=p1+sol_1*(p2-p1);
      , 
      ret=[i,i,i];
    );
  );
  ret;
);

// ２点p1,p2を結ぶ線分と２点p3,p4を結ぶ線分の交点
// 存在しないときは [i,i,i] を返す 
interss(p1,p2,p3,p4):=(
  regional(ip,vp,vpp,ret);

  ip=interll(p1,p2,p3,p4);

  ret=[i,i,i];

  if(ip!=[i,i,i],
    vp=p2-p1;
    vpp=ip-p1;
    if(vp/|vp|~=vpp/|vpp| & |vpp|<=|vp|,ret=ip);
  );

  ret;
);

// p1,p2,p3 で決まる平面と２点p4,p5を通る直線の交点
// 存在しないときは [i,i,i] を返す 
interpl(p1,p2,p3,p4,p5):=(
  regional(ret);

  MA=transpose([p2-p1,p3-p1,p4-p5]);
  MC=p4-p1;

  if(det(MA)!=0,
    sol=inverse(MA)*MC;
    ret=p4+sol_3*(p5-p4);
  , 
    ret=[i,i,i];
  );

  ret;
);


// p1,p2,p3 で決まる平面と２点p4,p5を結ぶ線分の交点
// 存在しないときは [i,i,i] を返す 
interps(p1,p2,p3,p4,p5):=(
  regional(ip,vp,vpp,ret);

  ip=interpl(p1,p2,p3,p4,p5);

  ret=[i,i,i];

  if(ip!=[i,i,i],
    vp=p5-p4;
    vpp=ip-p4;
    if(vp/|vp|~=vpp/|vpp| & |vpp|<=|vp|,ret=ip);
  );

  ret;
);

// ベクトル[va,vb,vc]に垂直な平面上に直交する基本ベクトルを作る
// flag はオプションで，1以外なら単位ベクトルにしない
perpvec(v):=perpvec(v,1);
perpvec(v,flag):=(
 regional(va,vb,vc,v1,v2);
 va=v_1;
 vb=v_2;
 vc=v_3;

 if(va!=0,
   v1=[-(vb+vc)/va,1,1];
   v2=linearsolve([[va,vb],[(vb+vc)/va,-1]],[-vc,1]);
   v2=[v2_1,v2_2,1];
   ,
   if(vb!=0,
     v1=[1,-vc/vb,1];
     v2=linearsolve([[vb,vc],[vc/vb,-1]],[0,1]);
     v2=[1,v2_1,v2_2];
     ,
     v1=[1,0,0];
     v2=[0,1,0];
   );
 );

 if(flag==1,[v1/|v1|,v2/|v2|],[v1,v2]);

);

// 法線ベクトルから回転行列をつくる
rotmatrix(vec):=(
 regional(uv,tha,thb,th);
 uv=vec/|vec|;

 th=Acos(uv_3);
 if(uv_1!=0,
   tha=th*vec_1/|vec_1|;
   ,
   tha=th;
 );
 if(sin(tha)!=0,
   thb=Asin(uv_2/sin(tha));
   ,
   thb=0;
 );
 rtz(thb)*rty(tha);
);

// 半径１の球面に内接する正多面体の頂点リストを返す
vertexrpolyhedron(n):=(
  regional(m,sc);
  m=1;
  sc=0;
  if(n==4,m=1;sc=1);
  if(n==6,m=2;sc=sqrt(3)/3);
  if(n==8,m=3;sc=1);
  if(n==12,m=4;sc=1/(sqrt(3)*φ));
  if(n==20,m=5;sc=1/sqrt(sqrt(5)*φ));

  sc*Rpolydata_m;
);

// プロットデータの処理　------------------------------------------------

// 点，PD，面データを回転する
rotate3d(dlist,vec,angle,center):=(
  regional(ret);
  if(length(dlist)==1,  // リストのリストで点を与えた
    ret=Rotatepoint3d(dlist_1,vec,angle,center);
  );
  if(length(dlist)==2,
    if(islist(dlist_1_1),
      dt=apply(dlist_1,Rotatepoint3d(#,vec,angle,center));
      ret=[dt,dlist_2];
      ,
      ret=apply(dlist,Rotatepoint3d(#,vec,angle,center));
    );
  );
  if(length(dlist)>2,
    if(length(dlist)==3 & isreal(dlist_1), // 点
      ret=Rotatepoint3d(dlist,vec,angle,center);
     ,
      ret=apply(dlist,Rotatepoint3d(#,vec,angle,center));
    ); 
  );
  ret;
);

// 点・直線・面に関する鏡像を返す
// dlist は点，PD，面データのいずれか
reflect3d(dlist,mirror):=(
  regional(ret);
  if(length(dlist)==1,
    ret=Reflectpoint3d(dlist_1,mirror);
  );
  if(length(dlist)==2,
    if(islist(dlist_1_1),
      dt=apply(dlist_1,Reflectpoint3d(#,mirror));
      ret=[dt,dlist_2];
      ,
      ret=apply(dlist,Reflectpoint3d(#,mirror));
    );
  );
  if(length(dlist)>2,
    if(length(dlist)==3 & isreal(dlist_1),
      ret=Reflectpoint3d(dlist,mirror);
     ,
      ret=apply(dlist,Reflectpoint3d(#,mirror));
    );
  );
  ret;
);

// dlist を平行移動する
translate3d(dlist,vec):=(
  regional(ret);
  if(length(dlist)==1,
    ret=Translatepoint3d(dlist_1,vec);
  );
  if(length(dlist)==2,
    if(islist(dlist_1_1),
      dt=apply(dlist_1,Translatepoint3d(#,vec));
      ret=[dt,dlist_2];
      ,
      ret=apply(dlist,Translatepoint3d(#,vec));
    );
  );
  if(length(dlist)>2,
    if(length(dlist)==3 & isreal(dlist_1),
      ret=Translatepoint3d(dlist,vec);
     ,
      ret=apply(dlist,Translatepoint3d(#,vec));
    );
  );
  ret;
);

// 数値をguess()で解析して分数，平方根の文字列にして返す
val2tex(x):=(
  regional(txt,p,slist);

  txt=guess(x);

  if((p=indexof(txt,"/"))>0,
    slist=tokenize(txt,"/");
    txt="\frac{"+slist_1+"}{"+slist_2+"}";
  );

  if((p=indexof(txt,"sqrt"))>0,
   txt=replace(txt,"(","{");
   txt=replace(txt,")","}");
   txt=replace(txt,"sqrt","\sqrt");
  );

  txt;
);

// optionの解析。戻り値は、Num,Alpha,Mesh を除外した option
parseoption(option):=(
  regional(col,add,p,ret);

  Display=true;
//  Rayon=false;
  col=[];
  ret=[];

  forall(option,
    add=true;
    if(isstring(#),
      if(indexof(#,"Num")>0 % indexof(#,"num")>0,
       if(isreal(parse(#)),
         Res=parse(#);
       );
       add=false;
      );
      if(indexof(#,"Mesh")>0 % indexof(#,"mesh")>0, 
       if(islist(parse(#)),
          Mesh=parse(#),
        );
       add=false;
      );
      if(indexof(#,"Rayon")>0 % indexof(#,"rayon")>0, 
        Rayon=true;
        add=false;
      );
      if(indexof(#,"Rayoff")>0 % indexof(#,"rayoff")>0, 
        Rayon=false;
        add=false;
      );
      if(indexof(#,"Alpha")>0 % indexof(#,"alpha")>0,
        Alpha3d=parse(#);
        add=false;
      );
      if(indexof(#,"Contrast")>0 % indexof(#,"contrast")>0,
        Contrast=parse(#);
        add=false;
      );
      if(indexof(#,"nodisp")>0,   
        Display=false;     // 画面表示フラグ 
      );
      if(indexof(#,"Col")>0,
        p=indexof(#,"=");
        str=substring(#,p,length(#));
        if(str_1_1=="[",
          col=parse(#);
          ,
          p=select(Colname,#_1==str);
          if(p!=[],col=p_1_2,col=[]);
        );
        if(length(col)==3,
          RGBcolor=col;
          if(col==[0,0,0],
            CMYKcolor=[0,0,0,1];
            ,
            CMYKcolor=Colorcode("rgb","cmyk",col);
          );
        );
        if(length(col)==4,
          CMYKcolor=col;
          RGBcolor=Colorcode("cmyk","rgb",col);
        );
      );
    );
    if(add,ret=append(ret,#));
  );

  ret;
);

//===========　描画　=================

// 方眼を描く関数 xw ,yw 範囲のリスト n:本数
grid():=(
  grid([-5,5],[-5,5],1,["Alpha=0.4"]);
  grid([-5,5],[-5,5],10,["Alpha=0.1"]);
);
grid(option):=(
  grid([-5,5],[-5,5],1,option);
  grid([-5,5],[-5,5],10,option);
);
grid(xw,yw,n):=grid(xw,yw,n,option);
grid(xw,yw,n,option):=(
  regional(col,alp);

  col=[0,0,1];
  alp=0.4;
  forall(option,
    if(isstring(#),
      if(indexof(#,"Alpha")>0 % indexof(#,"alpha")>0,
       if(isreal(parse(#)),alp=parse(#));
      );
      if(indexof(#,"Col")>0,
        p=indexof(#,"=");
        str=substring(#,p,length(#));
        if(str_1_1=="[",
          col=parse(#);
          ,
          p=select(Colname,#_1==str);
          if(p!=[],col=p_1_2;col=Colorcode("cmyk","rgb",col));
        );
      );
    );
  );

  apply((xw_1*n..xw_2*n)/n,s,
    draw(map2d([s,yw_1,0]),map2d([s,yw_2,0]),color->col,alpha->alp);
 );
  apply((yw_1*n..yw_2*n)/n,s,
    draw(map2d([xw_1,s,0]),map2d([xw_2,s,0]),color->col,alpha->alp,size->0.5);
 );

  constantreset();

);


//直線を描く
line3d(name,plist):=line3d(name,plist,[]);
line3d(name,plist,option):=(
  regional(vec,p1,p2);
  vec=plist_2-plist_1;
  p1=plist_1+10*vec;
  p2=plist_1-10*vec;
  Spaceline("ln"+name,[p1,p2],option);
);

// 矢線を描く
arrow3d(name,plist):=arrow3d(name,plist,[]);
arrow3d(name,plist,option):=(
  regional(p1,p2);
  p1=map2d(plist_1);
  p2=map2d(plist_2);
  Arrowhead("ar"+name,p2,p2-p1,option);
  Spaceline("ar"+name,plist,option);
);

//多角形を描く
poly3d(name,plist):=poly3d(name,plist,[]);
poly3d(name,plist,option):=(
  if(plist_1!=plist_(-1),plist=append(plist,plist_1));
  Spaceline("pl"+name,plist,option);
);

// 多角形を塗る Rayon で簡易レイトレーシング　戻り値はそのまま plist
plate3d(name,plist):=plate3d(name,plist,[]);
plate3d(name,plist,option):=(
  regional(pl,p1,p2,p3,nv,lv,cf,col,vp);
  parseoption(option);

  pl=apply(plist,map2d(#));
  Listplot("plt"+name,pl,["nodisp"]);

  col=Colorcode("cmyk","rgb",CMYKcolor*Alpha3d);

  if(Rayon,
    p1=plist_1;
    p2=plist_2;
    p3=plist_3;

    nv=normalvec(p1,p2,p3);
    lv=Lightpoint;
    lv=lv/|lv|;

    cf=1-(1-nv*lv)*Contrast/2;
    col=col*cf;
  );

  if(Display,Shade(["sg"+"plt"+name],["Color="+col]));

  constantreset();

  plist;
);

// 中心、半径と法線ベクトルを与えて円を描く 戻り値はプロットデータ
circle3d(name,center,nv,radius):=circle3d(name,center,nv,radius,[]);
circle3d(name,center,nv,radius,option):=(
  regional(mat,circ,deg,pd);

  Res=72;
  option=parseoption(option);
  
  deg=360/Res;
  mat=rotmatrix(nv);
  circ=apply((0..Res),radius*[cos(deg*#°),sin(deg*#°),0]);
  pd=apply(circ,mat*#+center);
println(pd);

  Spaceline("c"+name,pd,option);

  pd;
);

// 中心、半径、範囲と法線ベクトルを与えて弧を描く。範囲は弧度法
drawarc3d(name,center,nv,radius,range):=drawarc3d(name,center,nv,radius,range,[]);
drawarc3d(name,center,nv,radius,range,option):=(
  regional(deg,mat,circ,pd);

  Res=72;
  option=parseoption(option);

  deg=(range_2-range_1)/Res;
  mat=rotmatrix(nv);
  circ=apply((0..Res),radius*[cos(range_1+deg*#),sin(range_1+deg*#),0]);

  pd=apply(circ,mat*#+center);
  Spaceline("arc"+name,pd,option);

  pd;
);

// 円を塗る
disk3d(name,center,nv,radius):=disc3d(name,center,nv,radius,[]);
disc3d(name,center,nv,radius,option):=(
  regional(deg,mat,circ);

  Res=72;
  parseoption(option);
  deg=360/Res;
  mat=rotmatrix(nv);

  circ=apply((0..Res),radius*[cos(deg*#°),sin(deg*#°),0]);

  plate3d("dc"+name,apply(circ,(mat*#+center)),option);
);

// ハッチをかける 対象は，poly3d(),circle3d() の戻り値など空間の閉曲線
hatch3d(name,pd):=hatch3d(name,pd,[]);
hatch3d(name,pd,option):=(
  regional(plist);

  parseoption(option);

  plist=apply(pd,map2d(#));

  name="h3"+name;
  Listplot(name,plist);
  Hatchdata(name,["i"],[["sg"+name]],option);

);
// 向こう側に回り込んだ面を表示しない
surface4(name,fd):=surface4(name,fd,[]);
surface4(name,fd,option):=(
  regional(p,range1,range2,du,dv,u,v,c1,c2);

  if(fd_1=="p",p=2,p=1);
  form=fd_p;
  range1=parse(fd_(p+3));
  range2=parse(fd_(p+4));
  sfn3(u,v):=parse("["+fd_p+","+fd_(p+1)+","+fd_(p+2)+"]");

  parseoption(option); 

  du=(range1_2-range1_1)/Mesh_1;
  dv=(range2_2-range2_1)/Mesh_2;

  dencity=0.6;
  if(RGBcolor==Red,
     fcol(vec):=(
      c1=dencity*vec*(1,1,1);
      c2=dencity*vec*(1,1,2);
      [c1,0,c2];
     );
    ,
    if(RGBcolor==Green,
     fcol(vec):=(
      c1=dencity*vec*(1,1,1);
      c2=dencity*vec*(1,1,2);
     [c1,c2,0];
     );
     ,
     fcol(vec):=(
      c1=dencity*vec*(1,1,1);
      c2=dencity*vec*(1,1,2);
     [0,c1,c2];
     );
    );
  );

  forall(0..(Mesh_1-1),s,
    forall(0..(Mesh_2-1),t,
     u=range1_1+du*s;
     v=range2_1+dv*t;
     p1=sfn3(u,v);
     p2=sfn3(u+du,v);
     p3=sfn3(u+du,v+dv);
     p4=sfn3(u,v+dv);

// SpaceCindyからの定数
     const=[[-0.7,0.7,0],[0,0,1],[0.7,0.7,0.3]];
     nv=cross(const*(p1-p3),const*(p2-p4));
     if(nv!=[0,0,0],nv=nv/|nv|);   // 法線単位ベクトル

     pp=apply([p1,p2,p3],Parapt(#));

     if(area(pp_1,pp_2,pp_3)>0,
       co=fcol(nv);
       r1=min([1,max([co_1,0])]);
       g1=min([1,max([co_2,0])]);
       b1=min([1,max([co_3,0])]);
       plate3d("sf"+(s*20+t)+name,[p1,p2,p3,p4],["Color="+text([r1,g1,b1]),"Alpha=1"]);
      );
     ); 
  );
);

convexsurface(name,fd):=convexsurface(name,fd,[]);
convexsurface(name,fd,option):=(
  regional(vp,nv,form,range1,range2,m1,m2,du,dv,u,v,plist);

  parseoption(option);

  vp=viewpoint();
  m1=Mesh_1;
  m2=Mesh_2;

  if(fd_1=="p",p=2,p=1);
  form=fd_p;
  range1=parse(fd_(p+3));
  range2=parse(fd_(p+4));
  sfn3(u,v):=parse("["+fd_p+","+fd_(p+1)+","+fd_(p+2)+"]");
  du=(range1_2-range1_1)/m1;
  dv=(range2_2-range2_1)/m2;

  plist=[];
 forall(0..(m1-1),s,
   forall(0..(m2-1),t,
     u=range1_1+du*s;
     v=range2_1+dv*t;
     p1=sfn3(u,v);
     p2=sfn3(u+du,v);
     p3=sfn3(u+du,v+dv);
     p4=sfn3(u,v+dv);

     plist=[p1,p2,p3,p4];
     nv=normalvec(p1,p2,p3);
     if(vp*nv>0,
       plate3d("suf"+(s*100+t)+name,plist,option);
     ); 
   );
  );
);

//球面
drawsphere(name,center,r):=drawsphere(name,center,r,[]);
drawsphere(name,center,r,option):=(
  regional(fd);

  parseoption(option);

  if(islist(r),
    if(length(r)==2,
      r1=r_1; r2=r_1; r3=r_2;
      ,
      r1=r_1; r2=r_2; r3=r_3;
    );
    ,
    r1=r;r2=r;r3=r;
  );

  fd=["p",r1+"*sin(u)*cos(v)+("+center_1+")",r2+"*sin(u)*sin(v)+("+center_2+")",r3+"*cos(u)+("+center_3+")","u=[0,pi]","v=[0,2*pi]",""];

  convexsurface("sp"+name,fd,option);

);


//球面のようなもの
quasisphere(name,center,r):=quasisphere(name,center,r,1);
quasisphere(name,center,r,flag):=(
  if(islist(flag),
    quasisphere(name,center,r,1,flag);
    ,
    quasisphere(name,center,r,flag,[]);
  );
);
quasisphere(name,center,r,flag,option):=(
  regional(fd);

  parseoption(option);

  vp=viewpoint();

  if(flag==1,
    disc3d("qs"+name,center,vp,r,option);
    ,
    circle3d("qs"+name,center,vp,r,option);
  );


);


// 面データを与えて多面体を塗る
polyhedron(name,flist):=polyhedron(name,flist,[]);
polyhedron(name,flist,option):=(
  regional(vp,plist,face,fl,pt,nv);

  parseoption(option);
  vp=viewpoint();

  plist=flist_1;
  face=flist_2;

  repeat(length(face),s,
    fl=face_s;
    pt=[];                     // 面の頂点
    forall(fl,
      pt=append(pt,plist_#);
    );
    nv=normalvec(pt_1,pt_2,pt_3);
    if(vp*nv>0,plate3d("ph"+s+name,pt,option));
  );
  flist;
);


// 凸型多面体を塗る
// 頂点リストから面データを作って塗る sz:倍率 戻り値：面データ
convexhedron(name,plist):=convexhedron(name,plist,1,[]);
convexhedron(name,plist,arg):=(
  if(islist(arg),
    convexhedron(name,plist,1,arg);
    ,
    convexhedron(name,plist,arg,[]);
  );
);
convexhedron(name,plist,sz,option):=(
  regional(fd);
  fd=convexhull3d(plist);
  polyhedron("ch"+name,[sz*fd_1,fd_2],option);
  [sz*fd_1,fd_2];
);

// 正多面体を塗る n=4,6,8,12,20　戻り値は面データ
rpolyhedron(name,n,sz):=rpolyhedron(name,n,sz,[]);
rpolyhedron(name,n,sz,option):=(
  convexhedron("rph"+name,vertexrpolyhedron(n),sz,option);
);

// 正n角錐（台）の面を塗る。戻り値は面データ
frustum(name,n,r1,r2,h):=frustum(name,n,r1,r2,h,[]);
frustum(name,n,r1,r2,h,option):=(
  regional(pt1,pt2);
  
  if(r1>0, // 上底のリスト
    pt1=apply(0..(n-1),[r1*cos(#/n*2*pi),r1*sin(#/n*2*pi),h]);
   ,
    pt1=[[0,0,h]];
  );
  pt2=pt1++apply(0..(n-1),[r2*cos(#/n*2*pi),r2*sin(#/n*2*pi),0]);

  convexhedron("fr"+name,pt2,1,option);
);

